# Contract Anatomy — SaaS OS

This document defines the **fixed anatomy of a SaaS OS contract**.

Every contract **must follow this structure**.
No sections may be removed.
No new sections may be invented.

Contracts exist to remove interpretation.

---

## 1. Contract Header

The header identifies **what is being contracted**.

Must include:
- Component name (canonical, e.g. `ui-input`)
- Scope (UI / Composite / Primitive)
- Version (e.g. V1)
- Status (Locked / Draft / Deprecated)

Example:

Contract — ui-input  
Scope: UI Primitive  
Version: V1  
Status: Locked

Rules:
- Component names must follow canonical naming rules.
- Non-canonical names invalidate the contract.

The header establishes authority.
If the header is unclear, the contract is invalid.

---

## 2. Intent

Intent answers **why this component exists**.

Rules:
- One short paragraph
- Describes purpose, not appearance
- Must not describe layout or styling

Intent defines:
- What problem this component solves
- What it is allowed to represent
- What it must never represent

Intent is normative.
Visuals and variants must never contradict intent.

If behaviour contradicts intent, the contract is broken.

---

## 3. State → Visual Mapping

This section defines **which primary states exist and how they are rendered**.

Rules:
- Only global state vocabulary is allowed
- States must be mutually exclusive
- Visuals must be token-driven

Must list:
- All supported primary states
- Explicitly unsupported states

Example primary states:
- default
- loading
- error
- empty

Notes:
- `disabled` must be represented as a property or modifier, not a primary state,
  unless explicitly defined otherwise in the contract.

This section defines **what may appear**, not *when* it appears.
Timing is never defined here.

---

## 4. Variants (If Any)

Variants define **structural differences**, not behaviour.

Rules:
- Variants must be finite and explicitly named
- Variants must not encode logic
- Variants must not imply state transitions
- Variants must not be used as a substitute for state

Variants may change:
- Layout
- Density
- Visual emphasis

Variants must not change:
- State ownership
- Behaviour
- Validation rules

If a variant implies logic, it is invalid.

---

## 5. Behavioural Contract

This is the most important section.

It defines **what the component does and does not own**.

Must explicitly state:
- What behaviour is owned by the UI
- What behaviour is owned by the application
- What behaviour is forbidden

Examples:
- UI renders state but does not infer outcomes
- UI emits intent but does not mutate data
- UI does not own timing, retries, or reconciliation

Rule:
- Absence of behaviour definition implies prohibition.

If behaviour is not listed here, it is not allowed.

---

## 6. Accessibility Guarantees

Accessibility is contractual, not optional.

Must define:
- Roles (e.g. dialog, alertdialog)
- Focus behaviour
- Keyboard interaction
- Screen reader announcements (ARIA)

Rules:
- Accessibility must not depend on implementation guesswork
- Focus rules must be explicit
- Screen reader behaviour must be deterministic
- Accessibility guarantees must be testable

If accessibility behaviour varies by implementation, the contract is incomplete.

---

## 7. Token Usage Rules

This section defines **what tokens may control**.

Allowed token categories:
- color.*
- space.*
- typography.*
- radius.*
- elevation.*
- focus.*

Rules:
- No raw values
- No local overrides
- No component-specific colours
- Tokens define appearance, not meaning
- Tokens may define focus presentation, never focus behaviour

If a visual value is not token-driven, the contract is violated.

---

## 8. Composition Rules

Defines how this component may be composed with others.

Must specify:
- Allowed parents
- Allowed children
- Forbidden nesting

Rules:
- Composition must not introduce new behaviour
- Parent owns data and lifecycle
- Child owns presentation only

Composition must never bypass contracts.

---

## 9. Allowed Changes (Future Versions)

Defines what may evolve without breaking consumers.

Typically allowed:
- Token value changes
- Accessibility improvements
- Additive, non-breaking slots
- Documentation clarifications

Not allowed:
- Renaming the component
- Changing state meaning
- Adding behaviour
- Encoding logic

Any change that alters observable behaviour requires a new major version.

---

## 10. Explicit Non-Goals

Every contract must state what it will **never do**.

Examples:
- Will not own persistence
- Will not perform validation
- Will not encode business rules
- Will not manage timing or retries

Non-goals prevent scope creep.

---

## 11. Contract Status

Every contract must declare its status.

Valid statuses:
- Locked
- Draft
- Deprecated

Rules:
- Production systems must rely only on Locked contracts
- Draft contracts must not be used in production

---

## Canonical Rule

If there is a conflict between:
- Contract
- Visual example
- Code
- Tool output

**The contract wins.**

Contracts are the system of record.